/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.door.fancy;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import org.jetbrains.annotations.NotNull;

public class FancyDoorsBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public FancyDoorsBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getFancyDoor());
    }

    private void createBlockstateFile(HashCache cache, FancyDoorBlock shingle) throws IOException {
        if (shingle.getRegistryName() == null) {
            return;
        }
        HashMap<CallSite, BlockstateVariantJson> variants = new HashMap<CallSite, BlockstateVariantJson>();
        for (Direction facingValue : BlockStateProperties.f_61374_.m_6908_()) {
            for (FancyDoorType typeValue : FancyDoorBlock.TYPE.m_6908_()) {
                for (DoubleBlockHalf halfValue : DoorBlock.f_52730_.m_6908_()) {
                    Iterator iterator = BlockStateProperties.f_61446_.m_6908_().iterator();
                    while (iterator.hasNext()) {
                        boolean openValue = (Boolean)iterator.next();
                        for (DoorHingeSide hingeValue : DoorBlock.f_52728_.m_6908_()) {
                            String variantKey = "facing=" + facingValue + ",type=" + typeValue.m_7912_() + ",half=" + halfValue + ",open=" + openValue + ",hinge=" + hingeValue;
                            int y = this.getYFromFacing(facingValue);
                            String modelLocation = "domum_ornamentum:block/doors/fancy/door_" + (halfValue == DoubleBlockHalf.UPPER ? "top_" : "") + typeValue.m_7912_();
                            BlockstateModelJson model = new BlockstateModelJson(modelLocation, 0, y += this.getYFromOpenAndHinge(openValue, hingeValue));
                            BlockstateVariantJson variant = new BlockstateVariantJson(model);
                            variants.put((CallSite)((Object)variantKey), variant);
                        }
                    }
                }
            }
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(shingle.getRegistryName().m_135815_() + ".json");
        DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.WEST -> 180;
            case Direction.NORTH -> 270;
            case Direction.SOUTH -> 90;
        };
    }

    private int getYFromOpenAndHinge(boolean open, DoorHingeSide half) {
        if (!open) {
            return 0;
        }
        return 90 + (half == DoorHingeSide.RIGHT ? 180 : 0);
    }

    @NotNull
    public String m_6055_() {
        return "Fancy Doors BlockStates Provider";
    }
}

